#include <windows.h>
#include <stdio.h>
#include <tchar.h>
#include "nvapi.h"

int _tmain(int argc, _TCHAR* argv[])
{
    NvAPI_Status ret = NVAPI_OK;

    ret = NvAPI_Initialize();
    if (ret != NVAPI_OK)
    {
        printf("NvAPI_Initialize() failed = 0x%x", ret);
        return 1; // Initialization failed
    }
 
    NvPhysicalGpuHandle nvGPUHandle[NVAPI_MAX_PHYSICAL_GPUS] = { 0 };
    NvU32 gpuCount = 0;

    // Get all Physical GPU Handles
    ret = NvAPI_EnumPhysicalGPUs(nvGPUHandle, &gpuCount);
    if (ret != NVAPI_OK)
    {
        printf("Get GPU Error!\n");
        getchar();
        return -1;
    }
    
    printf("GPU count: %d\n", gpuCount);

    NvU32 connected_displays = 0;
    NvU32 busId = 0;
    NvU32 busSlotId = 0;
    NvU32 gpuId;

    int numread, i, j;
    int firstValidOutputID = 255;

    NV_EDID edid;

    for (gpuId = 0; gpuId < gpuCount; gpuId++) {
        NvAPI_GPU_GetConnectedDisplayIds(nvGPUHandle[gpuId], NULL, &connected_displays, NULL);
        NvAPI_GPU_GetBusId(nvGPUHandle[gpuId], &busId);
        NvAPI_GPU_GetBusSlotId(nvGPUHandle[gpuId], &busSlotId);

        printf("Current GPU device: %d\n", gpuId);
        printf("Number of connected displays: %u\n", connected_displays);
        printf("Bus id: %u\tBus slot id: %u\n", busId, busSlotId);

        memset(&edid, 0, sizeof(NV_EDID));
        edid.version = NV_EDID_VER;

        // Check available displayOutputIds and Clear all current EDID(s)
        edid.sizeofEDID = 0;

        printf("\nGPU[%d] Unload EDID(s) and check OutIDs:\n01234567890123456789012345678901\n", gpuId);
        for (i = 0; i <= 31; i++) {
            ret = NvAPI_GPU_SetEDID(nvGPUHandle[gpuId], 1 << i, &edid);
            if (ret == NVAPI_OK) {
                if (firstValidOutputID == 255) {
                    firstValidOutputID = i;
                }
                printf("O");
            }
            else {
                printf("-");
            }
        }
        printf("\n\n");

        errno_t err;
        FILE* fd;

        printf("Load EDID data from file edid.bin\n");
        //Readin data from file edid.dat
        if ((err = fopen_s(&fd, "edid.bin", "rb")) == 0) {
            numread = fread_s(edid.EDID_Data, 256, 1, 256, fd);
            fclose(fd);
        }
        else {
            printf("Error Open edid.bin!\n");
            getchar();
            return -1;
        }

        edid.sizeofEDID = 256;

        // Only enable and load EDID on first DFP.
        ret = NvAPI_GPU_SetEDID(nvGPUHandle[gpuId], 1 << firstValidOutputID, &edid);
        if (ret == NVAPI_OK) {
            printf("GPU[%d] SetEDID OK.\n", gpuId);
        }

        // Dump EDID(s)
        for (i = 0; i < 31; i++) {
            ret = NvAPI_GPU_GetEDID(nvGPUHandle[gpuId], 1 << i, &edid);
            if (ret == NVAPI_OK) {
                printf("\nGPU[%d] Found dispOutId at: %d\n", gpuId, i);
                printf("EDID Data:\n");
                for (j = 0; j < 256; j++) {
                    printf("%02x ", edid.EDID_Data[j]);
                    if (j % 16 == 15) {
                        printf("\n");
                    }
                }
                printf("\n");
            }
        }
        printf("\n\n");
    }
    printf("Done. Press Enter to exit.");
    getchar();
    return 0;
}

